/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.property.appspace;

import filenet.vw.api.VWWorkBasketDefinition;
import filenet.vw.toolkit.admin.resources.VWResource;
import filenet.vw.toolkit.utils.VWStringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;

public class VWInbasketListCellRenderer
extends DefaultListCellRenderer
implements TableCellRenderer {
    protected static final Border BORDER_NO_FOCUS = new EmptyBorder(1, 1, 1, 1);
    protected static final Border BORDER_INSETS = new EmptyBorder(new Insets(5, 5, 5, 5));

    public void releaseReferences() {
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        block15: {
            this.setComponentOrientation(table.getComponentOrientation());
            if (isSelected) {
                this.setForeground(table.getSelectionForeground());
                this.setBackground(table.getSelectionBackground());
            } else {
                this.setForeground(table.getForeground());
                this.setBackground(table.getBackground());
            }
            this.setFont(table.getFont());
            if (hasFocus) {
                Border border = null;
                if (isSelected) {
                    border = UIManager.getBorder("Table.focusSelectedCellHighlightBorder");
                }
                if (border == null) {
                    border = UIManager.getBorder("Table.focusCellHighlightBorder");
                }
                this.setBorder(new CompoundBorder(border, BORDER_INSETS));
                if (!isSelected && table.isCellEditable(row, column)) {
                    Color col = UIManager.getColor("Table.focusCellForeground");
                    if (col != null) {
                        this.setForeground(col);
                    }
                    if ((col = UIManager.getColor("Table.focusCellBackground")) != null) {
                        this.setBackground(col);
                    }
                }
            } else {
                this.setBorder(new CompoundBorder(BORDER_NO_FOCUS, BORDER_INSETS));
            }
            if (value != null && value instanceof VWWorkBasketDefinition) {
                try {
                    VWWorkBasketDefinition workBasketDef = (VWWorkBasketDefinition)value;
                    this.setText(workBasketDef.getName());
                    StringBuffer toolTip = new StringBuffer();
                    toolTip.append(VWResource.s_colon.toString(VWResource.QueueName));
                    toolTip.append(workBasketDef.getQueueName());
                    String desc = workBasketDef.getDescription();
                    if (desc != null && desc.length() > 0) {
                        toolTip.append("\n");
                        toolTip.append(VWResource.s_colon.toString(VWResource.Description));
                        toolTip.append(desc);
                    }
                    String toolTipStr = VWStringUtils.formatToolTip(toolTip.toString(), -1);
                    if (toolTip != null && toolTip.length() > 0) {
                        this.setToolTipText(toolTipStr);
                        break block15;
                    }
                    this.setToolTipText(null);
                }
                catch (Exception ex) {
                    this.setToolTipText(null);
                }
            } else {
                this.setToolTipText(null);
            }
        }
        return this;
    }
}

